<?php 
    // include('../lib/dbcon.php');
    // dbcon();

    session_start();
    //Check whether the session variable SESS_mEmBER_ID is present or not
    if (isset($_SESSION['staf_id'])) {
        header("location:index.php");
        exit();
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Form For Staf</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.1/css/all.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        html {
            margin: 0;
            padding: 0;
            height: 100vh;
            background: #C8C3C3 !important;
        }

        body {
            background-image: url('pexels-pixabay-531756.jpg');
            background-size: 100% 100%;
            background-repeat: no-repeat;
        }

        .user_card {
            height: 400px;
            max-width: 350px;
            width: 100%;
            margin: auto 0px;
            background: #150781;
            position: relative;
            display: flex;
            justify-content: center;
            flex-direction: column;
            padding: 10px;
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);
            border-radius: 5px;
        }

        .brand_logo_container {
            position: absolute;
            height: 170px;
            width: 170px;
            top: -75px;
            border-radius: 50%;
            background: #ffffff;
            padding: 10px;
            text-align: center;
        }

        .brand_logo {
            height: 150px;
            width: 150px;
            border-radius: 50%;
            border: 2px solid white;
        }

        .form_container {
            margin-top: 100px;
        }

        .login_btn {
            width: 100%;
            background: #6b3b0e !important;
            color: white !important;
        }

        .login_btn:focus {
            box-shadow: none !important;
            outline: 0px !important;
        }

        .login_container {
            padding: 0 2rem;
        }

        .input-group-text {
            background: #6b3b0e !important;
            color: white !important;
            border: 0 !important;
            border-radius: 0.25rem 0 0 0.25rem !important;
        }

        .input_user,
        .input_pass:focus {
            box-shadow: none !important;
            outline: 0px !important;
        }

        .links,
        .custom-control-label {
            color: #fff !important;
        }

        .custom-checkbox .custom-control-input:checked~.custom-control-label::before {
            background-color: #6b3b0e !important;
        }

        a {
            color: white;
            text-decoration: none;
            background-color: transparent;
            -webkit-text-decoration-skip: objects;
        }
    </style>

</head>

<body>
    <?php
    
        function httpPost($url, $data)
        {
            $ch = curl_init($url);

            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            
            curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
            $response = curl_exec($ch);
            
            curl_close($ch);

            return $response;
        }

       
        $email='';
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            
            $email=$_POST['email'];
            $password=$_POST['password'];

            $url="https://cmclnmu.ac.in/login-API/api/login";
            $data = array('email' => $email, 'password' => $password);
            $response= httpPost($url, $data);
            
            $data1 = json_decode($response);
            // var_dump($data1);
            if(!$data1->error){
                 $id = $data1->data->id;
                 $name = $data1->data->name;
                 $email = $data1->data->email;
                 $phone_no = $data1->data->phone_no;
                 
                 session_start();
                 $_SESSION['staf_id']=$id;
                 $_SESSION['staf_name']=$name;
                 $_SESSION['staf_email']=$email;
                 $_SESSION['staf_phone_no']=$phone_no;
                
            }else{
                // echo $data1->error; 
                 echo"<script>Swal.fire({icon: 'error',title: 'Oops...',text: 'Invalid username or password!',})</script>";
                
            }
                
            
        }
    
    ?>
    <div class="container" style="height: 100vh;">
        <div class="d-flex justify-content-center w-100 p-0 m-0" style="height: 100vh;">
            <div class="user_card">
                <div class="d-flex justify-content-center">
                    <div class="brand_logo_container">
                        <img src="ithub_logo.png" class="brand_logo" alt="Logo">
                    </div>
                </div>

                <form action="" method="post">

                    <div class="d-flex justify-content-center form_container">

                        <div>
                            <div class="input-group mb-3">
                                <div class="input-group-append">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                </div>
                                <input type="text" name="email" id="email" class="form-control input_user"
                                    placeholder="username or email" value="<?= $email;?>">
                            </div>
                            <div class="input-group mb-2">
                                <div class="input-group-append">
                                    <span class="input-group-text"><i class="fas fa-key"></i></span>
                                </div>
                                <input type="password" name="password" id="password" class="form-control input_pass"
                                    placeholder="password">
                            </div>
                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="customControlInline">
                                    <label class="custom-control-label" for="customControlInline">Remember
                                        Password</label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="d-flex justify-content-center mt-3 login_container">
                        <button type="submit" name="button" id="submit" class="btn login_btn">Login</button>
                    </div>

                </form>

                <div class="mt-4">
                    <div class="d-flex justify-content-center links">
                        Don't have an account? <a href="#" class="ml-2">Sign Up</a>
                    </div>
                    <div class="d-flex justify-content-center links">
                        <a href="#">Forgot your password?</a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script>
        $("#submit").click(function(){
            var email = $("#email").val();
            var password = $("#password").val();
            if(email !='' && email != undefined && password !='' && password != undefined){
                $.ajax({
                    type: "POST",
                    url: "https://cmclnmu.ac.in/login-API/api/login",
                    data: {"email":email, "password":password},
                    success: function (response) {
                        console.log(response['error']);
                       console.log(response);
                    }
                });
            }
        });

    </script>

</body>

</html>