<?php
include('lib/dbcon.php');
dbcon();
include_once('session.php');

$sql = mysql_query("SELECT * FROM `news` WHERE status=1");

while ($row = mysql_fetch_assoc($sql)) {
    $newsData[] = $row;
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
    <style>
        .lodar-div {
            position: absolute;
            z-index: 1056;
            height: 100vh;
            width: 100vw;
            background-color: #00000020;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .loader {
            transform: rotateZ(45deg);
            perspective: 1000px;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            color: #000000;
        }

        .loader:before,
        .loader:after {
            content: '';
            display: block;
            position: absolute;
            top: 0;
            left: 0;
            width: inherit;
            height: inherit;
            border-radius: 50%;
            transform: rotateX(70deg);
            animation: 1s spin linear infinite;
        }

        .loader:after {
            color: #FF3D00;
            transform: rotateY(70deg);
            animation-delay: .4s;
        }

        @keyframes rotate {
            0% {
                transform: translate(-50%, -50%) rotateZ(0deg);
            }

            100% {
                transform: translate(-50%, -50%) rotateZ(360deg);
            }
        }

        @keyframes rotateccw {
            0% {
                transform: translate(-50%, -50%) rotate(0deg);
            }

            100% {
                transform: translate(-50%, -50%) rotate(-360deg);
            }
        }

        @keyframes spin {

            0%,
            100% {
                box-shadow: .4em 0px 0 0px currentcolor;
            }

            12% {
                box-shadow: .4em .4em 0 0 currentcolor;
            }

            25% {
                box-shadow: 0 .4em 0 0px currentcolor;
            }

            37% {
                box-shadow: -.4em .4em 0 0 currentcolor;
            }

            50% {
                box-shadow: -.4em 0 0 0 currentcolor;
            }

            62% {
                box-shadow: -.4em -.4em 0 0 currentcolor;
            }

            75% {
                box-shadow: 0px -.4em 0 0 currentcolor;
            }

            87% {
                box-shadow: .4em -.4em 0 0 currentcolor;
            }
        }
    </style>
</head>

<body>
    <!-- Add Modal -->
    <div class="modal fade" id="addModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add New Notice</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="container">
                        <form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" id="addFrom" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col">
                                    <label for="title" class="form-label">Title *</label>
                                    <input type="text" name="title" id="title" class="form-control" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <label for="course" class="form-label">Course *</label>
                                    <select name="course" id="course" class="form-select" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label for="link_name" class="form-label">Link Name *</label>
                                    <select name="link_name" id="link_name" class="form-select" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="desc" class="form-label">Description *</label>
                                    <textarea name="desc" id="desc" cols="30" rows="5" class="form-control" required></textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <label for="file" class="form-label">File</label>
                                    <input type="file" accept=".jpg,.jpeg,.png,.pdf" name="file" id="file" class="form-control">
                                </div>
                                <input type="hidden" name="addData" value="1">
                            </div>
                            <div class="row justify-content-center mt-4">
                                <div class="col-2">
                                    <input type="submit" name="addNotice" value="Submit" class="btn btn-primary w-100">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- edit Modal -->
    <div class="modal fade" id="editModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Edit Notice</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="container">
                        <form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" id="editFrom" method="post" enctype="multipart/form-data">
                            <input type="hidden" name="id" id="notice_id">
                            <input type="hidden" name="edit_file_temp" id="edit_file_temp">
                            <div class="row">
                                <div class="col">
                                    <label for="edit_title" class="form-label">Title *</label>
                                    <input type="text" name="edit_title" id="edit_title" class="form-control" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <label for="edit_course" class="form-label">Course *</label>
                                    <select name="edit_course" id="edit_course" class="form-select" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <label for="edit_link_name" class="form-label">Link Name *</label>
                                    <select name="edit_link_name" id="edit_link_name" class="form-select" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label for="edit_desc" class="form-label">Description *</label>
                                    <textarea name="edit_desc" id="edit_desc" cols="30" rows="5" class="form-control" required></textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <label for="edit_file" class="form-label">File</label>
                                    <input type="file" accept=".jpg,.jpeg,.png,.pdf" name="edit_file" id="edit_file" class="form-control">

                                    <br>
                                    <a target="_blank" href="" id="fileAdd">Click Here To View The File</a>
                                </div>
                            </div>
                            <div class="row justify-content-center mt-4">
                                <div class="col-2">
                                    <input type="submit" value="Submit" class="btn btn-primary w-100">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="lodar-div" style="display: none;">
        <span class="loader"></span>
    </div>

    <div class="container-fluid bg-secondary-subtle">
        <div class="row justify-content-between mx-1">
            <div class="col-1 p-1">
                <a href="dashboard.php" class="btn btn-primary">Home</a>
            </div>
            <div class="col-4">
                <h2 class="text-center">Manage Notice</h2>
            </div>
            <div class="col-2 p-1">
                <a class="btn btn-primary w-75" onclick="addNotice(this)" data-bs-toggle="modal" data-bs-target="#addModal">Add New Notice</a>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col">
                <table class="table table-hover text-center">
                    <thead>
                        <tr>
                            <th>SN</th>
                            <th>Title</th>
                            <th>Course</th>
                            <th>Link Name</th>
                            <th>File</th>
                            <th>Date</th>
                            <th>Operation</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($newsData as $key => $value) : ?>
                            <tr>
                                <td><?= $key + 1 ?></td>
                                <td><?= $value['title'] ?></td>
                                <td><?= $value['course'] ?></td>
                                <td><?= $value['link_name'] ?></td>
                                <td><a target="_blank" href="../uploads/<?= $value['file'] ?>">Click Here To View The File</a></td>
                                <td><?= date('d-m-Y', strtotime($value['upload_on'])) ?></td>
                                <td>
                                    <div class="d-flex justify-content-evenly">
                                        <button class="btn btn-warning" data-id="<?= $value['id'] ?>" onclick="editNotice(this)" data-bs-toggle="modal" data-bs-target="#editModal">Edit</button>
                                        <button class="btn btn-danger" data-id="<?= $value['id'] ?>" onclick="deleteNotice(this)">Delete</button>
                                    </div>
                                </td>
                            </tr>

                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="container-fluid bg-secondary-subtle fixed-bottom">
        <div class="row">
            <div class="col text-center p-1">
                <h4>&copy; <?= date('Y') ?></h4>

            </div>
        </div>
    </div>

    <script>
        function addNotice(e) {
            $.get('manage_notice_api.php?data=course', function(res, status) {
                if (status == 'success') {
                    if (res.code == 1) {
                        var courseData = res.data;
                        var courseHtml = $('#course').html();

                        courseData.map((name) => {
                            courseHtml = courseHtml + '<option value="' + name + '">' + name + '</option>';
                        })

                        $('#course').html(courseHtml)
                    }
                }
            })

            $('#course').change(function() {
                var course = this.value;
                $('#link_name').html('<option value="" selected>Select</option>');

                $.get('manage_notice_api.php?data=link_name&course=' + course, function(res, status) {
                    if (status == 'success') {
                        if (res.code == 1) {
                            var linkData = res.data;
                            var linkHtml = $('#link_name').html();

                            linkData.map((name) => {
                                linkHtml = linkHtml + '<option value="' + name.link + '">' + name.linkname + '</option>';
                            })

                            $('#link_name').html(linkHtml)
                        }
                    }
                })
            })
        }

        function editNotice(e) {
            var id = e.dataset.id;

            $.get('manage_notice_api.php?data=notice&id=' + id, function(res, status) {
                if (status == 'success') {

                    if (res.code == 1) {

                        var noticeData = res.data;
                        var course = noticeData.course;

                        $.get('manage_notice_api.php?data=course', function(res, status) {
                            if (status == 'success') {
                                if (res.code == 1) {
                                    var courseData = res.data;
                                    var courseHtml = $('#edit_course').html();

                                    courseData.map((name) => {

                                        courseHtml = courseHtml + '<option value="' + name + '">' + name + '</option>';

                                    })

                                    $('#edit_course').html(courseHtml)
                                    $('#edit_course').val(noticeData.course)
                                }
                            }

                        })
                        
                        
                        $('#edit_course').change(function() {
                            var course = this.value;
                            $.get('manage_notice_api.php?data=link_name&course=' + course, function(res, status) {
                                $('#edit_link_name').html('<option value="" selected>Select</option>');
                                if (status == 'success') {
                                    if (res.code == 1) {
                                        var linkData = res.data;
                                        var linkHtml = $('#edit_link_name').html();
            
                                        linkData.map((name) => {
                                            linkHtml = linkHtml + '<option value="' + name.link + '">' + name.linkname + '</option>';
                                        })
            
                                        $('#edit_link_name').html(linkHtml)
                                    }
                                }
                            })
                        })
                        
                        
                        $.get('manage_notice_api.php?data=link_name&course=' + course, function(res, status) {
                            if (status == 'success') {
                                if (res.code == 1) {
                                    var linkData = res.data;
                                    var linkHtml = $('#edit_link_name').html();

                                    linkData.map((name) => {
                                        linkHtml = linkHtml + '<option value="' + name.link + '">' + name.linkname + '</option>';
                                    })

                                    $('#edit_link_name').html(linkHtml)
                                    $('#edit_link_name').val(noticeData.link_name)
                                }
                            }
                        })

                        $('#edit_title').val(noticeData.title)
                        $('#edit_desc').val(noticeData.title)
                        $('#notice_id').val(noticeData.id)
                        $('#fileAdd').attr('href', '../uploads/' + noticeData.file)
                        $('#edit_file_temp').val(noticeData.file)
                    }
                }
            })

            $('#course').change(function() {
                var course = this.value;
                $('#link_name').html('<option value="" selected>Select</option>');

                $.get('manage_notice_api.php?data=link_name&course=' + course, function(res, status) {
                    if (status == 'success') {
                        if (res.code == 1) {
                            var linkData = res.data;
                            var linkHtml = $('#link_name').html();

                            linkData.map((name) => {
                                linkHtml = linkHtml + '<option value="' + name.link + '">' + name.linkname + '</option>';
                            })

                            $('#link_name').html(linkHtml)
                        }
                    }
                })
            })
        }


        function deleteNotice(e) {
            var delete_id = e.dataset.id
            $('.lodar-div').show()

            Swal.fire({
                title: 'Do you want To Delete The Notice?',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Yes',
                denyButtonText: `No`,
            }).then((result) => {
                if (result.isConfirmed) {

                    $.post('manage_notice_api.php', {
                        "delete_id": delete_id
                    }, function(res, status) {
                        if (res.code == 1) {
                            $('.lodar-div').hide()
                            Swal.fire('Saved!', '', 'success')
                            setTimeout(() => {
                                location.reload();
                            }, 1500)
                        }
                    })
                } else if (result.isDenied) {
                    Swal.fire('Changes are not saved', '', 'info')
                }
            })
        }

        $('#editFrom').submit(function(e) {
            e.preventDefault();
            $('.lodar-div').show();

            Swal.fire({
                title: 'Do you want to Update?',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Save',
                denyButtonText: `Don't save`,
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    var editData = new FormData(this);

                    $.ajax({
                        url: "manage_notice_api.php",
                        data: editData,
                        type: "POST",
                        processData: false,
                        contentType: false,
                        success: function(data) {
                            if (data.code == 1) {
                                console.dir(data)
                                $('.lodar-div').hide()
                                Swal.fire('Saved!', '', 'success')
                                setTimeout(() => {
                                    location.reload();
                                }, 1500)
                            }
                        },
                    })
                } else if (result.isDenied) {
                    Swal.fire('Changes are not saved', '', 'info')
                }
            })
        })


        $('#addFrom').submit(function(e) {
            e.preventDefault();
            $('.lodar-div').show();

            var addData = new FormData(this);

            $.ajax({
                url: "manage_notice_api.php",
                data: addData,
                type: "POST",
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.code == 1) {
                        console.dir(data)
                        $('.lodar-div').hide()
                        Swal.fire('Saved!', '', 'success')
                        setTimeout(() => {
                            location.reload();
                        }, 1500)
                    }
                },
            })
        })
    </script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
</body>

</html>